<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Facture</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0; padding: 0;
            background-color: #fff;
            color: #333;
        }
        .invoice-box {
            max-width: 800px;
            margin: 30px auto;
            padding: 30px;
            background-color: #fff;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            page-break-inside: avoid;
        }

        /* Header 50/50 */
        .header {
            display: flex;
            align-items: center;  
            justify-content: center; 
            gap: 10px; 
            margin-bottom: 40px;
        }

        .logo {
            width: 30px;
            height: 30px;
            flex-shrink: 0;
        }

        .logo img {
            width: 40px;
            height: 40px;
            object-fit: contain;
        }

        .company-name {
            font-size: 1.8rem;
            font-weight: bold;
            color: #222;
            line-height: 40px;
        }

        .info-container {
            display: table;
            width: 100%;
            margin-bottom: 25px;
        }

        .company-info,
        .client-info {
            display: table-cell;
            width: 50%;
            vertical-align: top;
        }

        .client-info {
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            background-color: #f9f9f9;
        }

        .invoice-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            page-break-inside: avoid;
        }

        .invoice-table th, 
        .invoice-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }

        .invoice-table th {
            background-color: #f2f2f2;
        }

        .totals-container {
            text-align: right;
            margin-top: 20px;
        }

        .totals-container p {
            margin: 5px 0;
        }

        .total-amount {
            font-size: 1.5em;
            color: #333;
        }

        .payment-method {
            text-align: right;
            margin-top: 10px;
        }

        .payment-method p {
            margin: 5px 0;
        }

        .footer {
            width: 100%;
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background-color: #fff;
            text-align: center;
            font-size: 0.7rem;
            padding: 4px 0;
            border-top: 1px solid #ddd;
            line-height: 1.1;
        }

        .footer p {
            margin: 2px 0;
            font-weight: normal;
        }

        .description-cell {
            word-wrap: break-word;
            white-space: normal;
            max-width: 200px;
            text-align: justify;
            vertical-align: top;
        }
    </style>
</head>
<body>

<div class="invoice-box">
    <!-- En-tête -->
    <div class="header">
        <div class="logo">
            @if(!empty($info->logo) && file_exists(public_path('img/' . $info->logo)))
                <img src="data:image/png;base64,{{ base64_encode(file_get_contents(public_path('img/' . $info->logo))) }}" alt="Logo" />
            @else
                <img src="data:image/png;base64,{{ base64_encode(file_get_contents(public_path('img/777.jpg'))) }}" alt="Logo par défaut" />
            @endif
        </div>
        <div class="company-name">
            {{ $info->nom ?? 'Nom de la Société' }}
        </div>
    </div>

    <!-- Infos livraison / client -->
    <div class="info-container">
        <div class="company-info">
            <p style="font-weight: bold;">Facture N° : {{ $ventes->ref }}</p>
             <p>Docier :2545</p>
            <p>Date : {{ $ventes->created_at }}</p>
        </div>
        <div class="client-info">
            <p><strong>Facturé à :</strong></p>
            <p>Nom : k/p>
            <p>ICE : f</p>
            <p>Téléphone : m</p>
        </div>
    </div>

    <!-- Section Infofret et Détails -->
    <div class="info-container" style="margin-bottom: 25px;">
        <div class="company-info" style="width: 50%; display: table-cell; vertical-align: top;">
         
            <p style="margin: 2px 0;">Navire: {{ $ventes->infofret->navire->nom ?? '' }}</p>
            <p style="margin: 2px 0;">Date d'arrivée: {{ $ventes->infofret->datearriver ?? '' }}</p>
            <p style="margin: 2px 0;">Provenance: {{ $ventes->infofret->provenance ?? '' }}</p>
            <p style="margin: 2px 0;">Désignation Marchandise: {{ $ventes->infofret->nombrecolis ?? '' }}</p>
            <p style="margin: 2px 0;">Nature Marchandise: {{ $ventes->infofret->nature->nom ?? '' }}</p>
            <p style="margin: 2px 0;">Expéditeur: {{ $ventes->infofret->exportateur->nom ?? '' }}</p>
        </div>

        <div class="client-info" style="width: 50%; display: table-cell; vertical-align: top; padding: 10px; border: 1px solid #ddd; border-radius: 5px; background-color: #f9f9f9;">
           
            <p style="margin: 2px 0;">Booking/BL: {{ $ventes->infofret->nbl ?? '' }} | TCN°: {{ $ventes->infofret->ntc ?? '' }}</p>
            <p style="margin: 2px 0;">Type de TC: {{ $ventes->infofret->type_tc ?? '' }}</p>
            <p style="margin: 2px 0;">Date départ: {{ $ventes->infofret->datedepart ?? '' }}</p>
            <p style="margin: 2px 0;">Destination: {{ $ventes->infofret->distination ?? '' }}</p>
            <p style="margin: 2px 0;">Poids Brut: {{ $ventes->infofret->poidbrut ?? '' }} KGS</p>
            <p style="margin: 2px 0;">Incoterm: {{ $ventes->infofret->incoterm ?? '' }}</p>
            <p style="margin: 2px 0;">Destinataire: {{ $ventes->infofret->importateur->nom ?? '' }}</p>
        </div>
    </div>

    <!-- Tableau des produits -->
    <table class="invoice-table">
        <thead>
            <tr style="text-align: center;">
                <th>Désignation</th>
                <th>PU</th>
                <th>Qté</th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
            @foreach($ventes->detaille_vente as $det)
                <tr>
                    <td class="description-cell">{{ $det->desc }}</td>
                    <td>{{ $det->prix_vente }}</td>
                    <td>{{ $det->quantite }}</td>
                    <td>{{ $det->total }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <!-- Totaux -->
    <div class="totals-container">
        @if($ventes->totalTVA == 0)
            <p><strong>Total : <span class="total-amount">{{ $ventes->prixtotal }} DH</span></strong></p>
        @else
            <p>Total : {{ $ventes->prixtotal }} DH</p>

            @if($ventes->totalremise > 0)
                <p>Remise : {{ $ventes->totalremise }} DH</p>
            @endif

            <p>TVA : {{ $ventes->totalTVA }} DH</p>

            <p><strong>Total TTC : <span class="total-amount">{{ $ventes->totalavecTVA }} DH</span></strong></p>
        @endif
    </div>

    <div class="payment-method">
        <p>Mode de paiement : {{ $ventes->modepaiement ?? '' }}</p>
    </div>
</div>

<!-- Footer -->
<div class="footer">
    <p>{{ $info->line1 ?? '' }}</p>
    <p>{{ $info->line2 ?? '' }}</p>
    <p>{{ $info->line3 ?? '' }}</p>
</div>

</body>
</html>
