@extends('layouts.appadmin')

@section('content')

<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
   
      <div class="container-fluid">
    <h1>Liste des dossiers</h1>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <!-- Bouton Ajouter -->
    <a href="{{ route('infofrets.create') }}" class="btn btn-primary mb-3">+ Ajouter nouveau dossier</a>

    <!-- Formulaire de recherche/filtre -->
    <form method="GET" action="{{ route('infofrets.index') }}" class="mb-3 d-flex gap-2">
        <input type="text" name="ref" class="form-control" placeholder="Référence" value="{{ request('ref') }}">
        <select name="exportimprt_id" class="form-control">
            <option value="">-- Import/Export --</option>
            <option value="1" {{ request('exportimprt_id')=='1' ? 'selected' : '' }}>Export</option>
            <option value="2" {{ request('exportimprt_id')=='2' ? 'selected' : '' }}>Import</option>
        </select>
        <select name="nature_id" class="form-control">
            <option value="">-- Nature --</option>
            @foreach($natures as $nature)
                <option value="{{ $nature->id }}" {{ request('nature_id')==$nature->id ? 'selected' : '' }}>
                    {{ $nature->nature }}
                </option>
            @endforeach
        </select>
        <button type="submit" class="btn btn-secondary">Filtrer</button>
    </form>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID</th>
                <th>Ref</th>
                <th>NTC</th>
                <th>NBL</th>
                <th>Provenance</th>
                <th>Destination</th>
                <th>Nature</th>
                <th>Compagnie</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        @foreach($infofrets as $infofret)
            <tr>
                <td>{{ $infofret->id }}</td>
                <td>{{ $infofret->ref }}</td>
                <td>{{ $infofret->ntc }}</td>
                <td>{{ $infofret->nbl }}</td>
                <td>{{ $infofret->provenance }}</td>
                <td>{{ $infofret->distination }}</td>
                <td>{{ $infofret->nature->nature ?? '' }}</td>
                <td>{{ $infofret->compagnie ?? '' }}</td>
                <td>
                    <a href="{{ route('infofrets.show', $infofret->id) }}" class="btn btn-info btn-sm">Voir</a>
                    <a href="{{ route('infofrets.edit', $infofret->id) }}" class="btn btn-warning btn-sm">Modifier</a>
                    <form action="{{ route('infofrets.destroy', $infofret->id) }}" method="POST" style="display:inline;">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Supprimer ?')">Supprimer</button>
                    </form>
                    <a href="{{ route('detailleinfos.index', $infofret->id) }}" class="btn btn-primary btn-sm mt-1">Détails</a>
                </td>
            </tr>
        @endforeach
        </tbody>
    </table>

    {{ $infofrets->appends(request()->query())->links() }}
</div></div></div>
@endsection
