@extends('layouts.appadmin')

@section('content')

<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
   
      <div class="container-fluid">
    <h1>Modifier Infofret #{{ $infofret->id }}</h1>

    <form action="{{ route('infofrets.update', $infofret->id) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="ntc">NTC</label>
                <input type="text" name="ntc" id="ntc" class="form-control" value="{{ $infofret->ntc }}" required>
            </div>
            <div class="col-md-6 mb-3">
                <label for="nbl">NBL</label>
                <input type="text" name="nbl" id="nbl" class="form-control" value="{{ $infofret->nbl }}">
            </div>

            <div class="col-md-6 mb-3">
                <label for="datedepart">Date de départ</label>
                <input type="date" name="datedepart" id="datedepart" class="form-control" value="{{ $infofret->datedepart }}">
            </div>
            <div class="col-md-6 mb-3">
                <label for="datearriver">Date d'arrivée</label>
                <input type="date" name="datearriver" id="datearriver" class="form-control" value="{{ $infofret->datearriver }}">
            </div>

            <div class="col-md-6 mb-3">
                <label for="provenance">Provenance</label>
                <input type="text" name="provenance" id="provenance" class="form-control" value="{{ $infofret->provenance }}">
            </div>
            <div class="col-md-6 mb-3">
                <label for="distination">Destination</label>
                <input type="text" name="distination" id="distination" class="form-control" value="{{ $infofret->distination }}">
            </div>

            <div class="col-md-6 mb-3">
                <label for="nature_id">Nature</label>
                <select name="nature_id" id="nature_id" class="form-control" required>
                    @foreach($natures as $nature)
                        <option value="{{ $nature->id }}" {{ $infofret->nature_id == $nature->id ? 'selected' : '' }}>
                            {{ $nature->nature }}
                        </option>
                    @endforeach
                </select>
            </div>

            <div class="col-md-6 mb-3">
                <label for="distination">Compagnie</label>
                <input type="text" name="compagnie" id="compagnie" class="form-control" value="{{ $infofret->navire }}">
            </div>

                 <div class="col-md-6 mb-3">
                <label for="distination">navire</label>
                <input type="text" name="navire" id="navire" class="form-control" value="{{ $infofret->navire }}">
            </div>

            <div class="col-md-6 mb-3">
                <label for="groupage_id">Groupage</label>
                <select name="groupage_id" id="groupage_id" class="form-control" required>
                    @foreach($groupages as $groupage)
                        <option value="{{ $groupage->id }}" {{ $infofret->groupage_id == $groupage->id ? 'selected' : '' }}>
                            {{ $groupage->groupage }}
                        </option>
                    @endforeach
                </select>
            </div>

            <div class="col-md-6 mb-3">
                <label for="exportimprt_id">Export / Import</label>
                <select name="exportimprt_id" id="exportimprt_id" class="form-control" required>
                    @foreach($exportimprts as $exp)
                        <option value="{{ $exp->id }}" {{ $infofret->exportimprt_id == $exp->id ? 'selected' : '' }}>
                            {{ $exp->exportimprts }}
                        </option>
                    @endforeach
                </select>
            </div>

            <div class="col-md-6 mb-3">
                <label for="ref">Référence</label>
                <input type="text" name="ref" id="ref" class="form-control" value="{{ $infofret->ref }}">
            </div>
        </div>

        <button type="submit" class="btn btn-success">Mettre à jour</button>
        <a href="{{ route('infofrets.index') }}" class="btn btn-secondary">Annuler</a>
    </form>
</div>
@endsection
php artisan make:model Produit -mcr