@extends('layouts.appadmin')

@section('content')

<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
   
      <div class="container-fluid">
    <h1>Ajouter un nouveau dossier</h1>

    <form action="{{ route('infofrets.store') }}" method="POST">
        @csrf

        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="ntc">NTC</label>
                <input type="text" name="ntc" id="ntc" class="form-control" required>
            </div>
            <div class="col-md-6 mb-3">
                <label for="nbl">NBL</label>
                <input type="text" name="nbl" id="nbl" class="form-control">
            </div>

            <div class="col-md-6 mb-3">
                <label for="datedepart">Date de départ</label>
                <input type="date" name="datedepart" id="datedepart" class="form-control">
            </div>
            <div class="col-md-6 mb-3">
                <label for="datearriver">Date d'arrivée</label>
                <input type="date" name="datearriver" id="datearriver" class="form-control">
            </div>

            <div class="col-md-6 mb-3">
                <label for="provenance">Provenance</label>
                <input type="text" name="provenance" id="provenance" class="form-control">
            </div>
            <div class="col-md-6 mb-3">
                <label for="distination">Destination</label>
                <input type="text" name="distination" id="distination" class="form-control">
            </div>

            <div class="col-md-6 mb-3">
                <label for="nature_id">Nature</label>
                <select name="nature_id" id="nature_id" class="form-control" required>
                    <option value="">Choisir Nature</option>
                    @foreach($natures as $nature)
                        <option value="{{ $nature->id }}">{{ $nature->nature }}</option>
                    @endforeach
                </select>
            </div>

          <div class="col-md-6 mb-3">
                <label for="distination">Compagnie</label>
                <input type="text" name="compagnie" id="compagnie" class="form-control">
            </div>

          <div class="col-md-6 mb-3">
                <label for="navire">Destination</label>
                <input type="text" name="navire" id="navire" class="form-control">
            </div>

            <div class="col-md-6 mb-3">
                <label for="groupage_id">Groupage</label>
                <select name="groupage_id" id="groupage_id" class="form-control" required>
                    <option value="">Choisir Groupage</option>
                    @foreach($groupages as $groupage)
                        <option value="{{ $groupage->id }}">{{ $groupage->groupage }}</option>
                    @endforeach
                </select>
            </div>

            <div class="col-md-6 mb-3">
                <label for="exportimprt_id">Export / Import</label>
                <select name="exportimprt_id" id="exportimprt_id" class="form-control" required>
                    <option value="">Choisir Export/Import</option>
                    @foreach($exportimprts as $exp)
                        <option value="{{ $exp->id }}">{{ $exp->exportimprts }}</option>
                    @endforeach
                </select>
            </div>

            <div class="col-md-6 mb-3">
                <label for="ref">Référence</label>
                <input type="text" name="ref" id="ref" class="form-control">
            </div>
        </div>

        <button type="submit" class="btn btn-success">Enregistrer</button>
        <a href="{{ route('infofrets.index') }}" class="btn btn-secondary">Annuler</a>
    </form>
</div>
@endsection
