@extends('layouts.appadmin')

@section('content')
<div class="container py-4">
    <div class="row justify-content-center">
        <div class="col-lg-8">

            {{-- Message succès --}}
            @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Fermer"></button>
                </div>
            @endif

            {{-- Erreurs de validation --}}
            @if($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="card shadow-sm border-0">
                <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><i class="fas fa-building me-2"></i>Informations Entreprise</h5>
                    <small>Ajouter / Modifier</small>
                </div>

                <form method="POST" action="{{ asset('addinfo') }}" enctype="multipart/form-data" class="p-3">
                    @csrf

                    <div class="mb-3">
                        <label for="nom" class="form-label">Nom de l'entreprise <span class="text-danger">*</span></label>
                        <input id="nom" type="text" name="nom" value="{{ old('nom', $info->nom ?? '') }}" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label for="tele" class="form-label">Téléphone</label>
                        <input id="tele" type="text" name="tele" value="{{ old('tele', $info->tele ?? '') }}" class="form-control" placeholder="+212 6 ...">
                    </div>

                    <div class="mb-3">
                        <label for="adress" class="form-label">Adresse</label>
                        <textarea id="adress" name="adress" rows="2" class="form-control">{{ old('adress', $info->adress ?? '') }}</textarea>
                    </div>

                    <div class="row g-3">
                        <div class="col-md-4">
                            <label for="rib" class="form-label">RIB</label>
                            <input id="rib" type="text" name="rib" value="{{ old('rib', $info->rib ?? '') }}" class="form-control">
                        </div>
                        <div class="col-md-4">
                            <label for="ice" class="form-label">ICE</label>
                            <input id="ice" type="text" name="ice" value="{{ old('ice', $info->ice ?? '') }}" class="form-control">
                        </div>
                        <div class="col-md-4">
                            <label for="image" class="form-label">Logo</label>
                            <input id="image" type="file" name="image" class="form-control">
                            @if(!empty($info->logo))
                                <div class="mt-2 d-flex align-items-center gap-3">
                                    <img src="{{ asset('img/'.$info->logo) }}" alt="Logo" style="height:60px; width:auto;" class="border rounded">
                                    <a href="{{ asset('img/'.$info->logo) }}" target="_blank" class="link-primary small">Voir l'image actuelle</a>
                                </div>
                            @endif
                        </div>
                    </div>

                    <hr class="my-4">

                    <h6>Lignes personnalisées (Footer / Facture)</h6>

                    <div class="mb-3">
                        <label for="line1" class="form-label">Ligne 1</label>
                        <input id="line1" type="text" name="line1" value="{{ old('line1', $info->line1 ?? '') }}" class="form-control" placeholder="Ex: Société X - Siège social ...">
                    </div>

                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="line2" class="form-label">Ligne 2</label>
                            <input id="line2" type="text" name="line2" value="{{ old('line2', $info->line2 ?? '') }}" class="form-control" placeholder="Ex: SIRET, TVA ...">
                        </div>
                        <div class="col-md-6">
                            <label for="line3" class="form-label">Ligne 3</label>
                            <input id="line3" type="text" name="line3" value="{{ old('line3', $info->line3 ?? '') }}" class="form-control" placeholder="Ex: Horaires, note ...">
                        </div>
                    </div>

                    <div class="mt-4 d-flex justify-content-end gap-2">
                        <button type="reset" class="btn btn-outline-secondary"><i class="fas fa-undo"></i> Réinitialiser</button>
                        <button type="submit" class="btn btn-success"><i class="fas fa-save"></i> Enregistrer</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
