<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Facture</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #fff;
            position: relative;
        }

        .invoice-box {
            max-width: 800px;
            margin: 0 auto;
            padding: 30px;
            background-color: #fff;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.15);
            page-break-inside: avoid;
        }

        h1 {
            text-align: center;
            color: #333;
            margin-top: 0;
        }

        .invoice-date {
            text-align: right;
            margin-bottom: 20px;
            font-style: italic;
        }

        .info-container {
            display: table;
            width: 100%;
            margin-bottom: 20px;
        }

        .company-info,
        .client-info {
            display: table-cell;
            width: 50%;
            vertical-align: top;
        }

        .client-info {
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            background-color: #f9f9f9;
        }

        .invoice-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            page-break-inside: avoid;
        }

        .invoice-table th, .invoice-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }

        .invoice-table th {
            background-color: #f2f2f2;
        }

        .totals-container {
            text-align: right;
            margin-top: 20px;
        }

        .totals-container p {
            margin: 5px 0;
        }

        .total-amount {
            font-size: 1.5em;
            color: #333;
        }

        .total-in-words {
            font-style: italic;
            font-size: 0.9em;
        }

        .payment-method {
            text-align: right;
            margin-top: 10px;
        }

        .payment-method p {
            margin: 5px 0;
        }

        .separator-line {
            border: none;
            border-top: 2px solid #ddd;
            margin: 20px 0;
        }

        .footer {
            width: 100%;
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            padding: 10px;
            background-color: #fff;
            text-align: center;
            font-size: 0.9em;
            border-top: 1px solid #ddd;
            page-break-inside: avoid;
        }

        .footer p {
            margin: 5px 0;
        }


  
    .invoice-table {
        width: 100%;
        border-collapse: collapse;
    }

    .invoice-table th, .invoice-table td {
        border: 1px solid #ddd;
        padding: 8px;
        text-align: justify; /* Alignement par défaut pour toutes les cellules */
    }

    .description-cell {
        word-wrap: break-word; /* Gère les mots longs */
        white-space: normal;   /* Permet le retour à la ligne */
        max-width: 200px;      /* Limite la largeur de cette colonne */
        text-align: justify;   /* Justifie le texte dans cette cellule */
        vertical-align: top;   /* Aligne le texte en haut si nécessaire */
    }
</style>


</head>
<body>
    <div class="invoice-box">
        <h1>Facture</h1>
        <p class="invoice-date">Date :  {{$ventes->created_at}}</p>

        <div class="info-container">
            <div class="company-info">

            @foreach($info as $inf)
                <p><strong> {{$inf->nom}}</strong></p>
                <p>Adresse de l'entreprise</p>
                <p>Téléphone: 0123 456 789</p>
                <p>Email: contact@entreprise.com</p>
                @endforeach
            </div>
      

         

            <div class="client-info">
            <p><strong>Facturé à :</strong></p>
                <p>{{$ventes->client->nom}}</p>
                <p>Adresse du Client</p>
                <p>Téléphone: {{$ventes->client->tele}}</p>
                <p>Email: client@email.com</p>
            </div>
        </div>

      <table class="invoice-table">
    <thead>
        <tr>
            <th>Designation</th>
            <th>Long</th>
            <th>Larg</th>
          
            <th>Metrage</th>
            <th>PU</th>
            <th>TOTAL</th>
        </tr>
    </thead>
    <tbody>
        @foreach($ventes->detaille_vente as $det)
            <tr>
                <td class="description-cell">
                    {{$det->nom}} <br>
                    {{$det->comme}}
                </td>
              
                <td>{{$det->langeur}}</td>
                <td>{{$det->largeur}}</td>
                <td>{{$det->metrage}}</td>
                
                <td>{{$det->prixvents}}</td>
              
                <td>{{$det->x}}</td>
            </tr>
        @endforeach
    </tbody>
</table>



        <div class="totals-container">
            <p>Total HT : {{$ventes->prixtotal}} DH</p>
            <p>Remise : - 0</p>
            <p>TVA (20%) : 0</p>
            <p><strong>Total TTC : <span class="total-amount">{{$ventes->prixtotal}} DH</span></strong></p>
            <p class="total-in-words">Total TTC en lettres : trois cent vingt-quatre euros</p>
        </div>

        <div class="payment-method">
            <p><strong>Mode de paiement :</strong> Virement bancaire</p>
        </div>
    </div>

    <div class="footer">
    @foreach($info as $inf)
        <p><strong>{{$inf->nom}} </strong> - 123 Rue de l'Exemple, 75000 Paris, France</p>
        <p>Téléphone : 01 23 45 67 89 | Email : contact@entreprise.com | Site Web : www.entreprise.com</p>
        <p>SIRET : 123 456 789 00010 | TVA : FR12 345678901</p>
        @endforeach
    </div>
</body>
</html>


